'/***
'*stdio.h - definitions/declarations for standard I/O routines
'*
'*       Copyright (c) 1985-1997, Microsoft Corporation. All rights reserved.
'*
'*Purpose:
'*       This file defines the structures, values, macros, and functions
'*       used by the level 2 I/O ("standard I/O") routines.
'*       [ANSI/System V]
'*
'*       [Public]
'*
'****/

#If Not %Def(%STDIO_INC)
    %STDIO_INC = 1

'/*
' * Currently, all MS C compilers for Win32 platforms default to 8 byte
' * alignment.
' */
'#pragma pack(push,8)

'typedef unsigned int size_t;
'typedef unsigned short wchar_t;
'typedef wchar_t wint_t;
'typedef wchar_t wctype_t;

'#ifndef _VA_LIST_DEFINED
'typedef char *  va_list;
'#define _VA_LIST_DEFINED

'/* Buffered I/O macros */

'#IF %DEF(%M_MPPC)
'%BUFSIZ = 4096
'#ELSE
%BUFSIZ = 512
'#ENDIF

'/*
' * Default number of supported streams. _NFILE is confusing and obsolete, but
' * supported anyway for backwards compatibility.
' */
%NSTREAM = 512

'/*
' * Number of entries in _iob[] (declared below). Note that _NSTREAM_ must be
' * greater than or equal to _IOB_ENTRIES.
' */
%IOB_ENTRIES = 20

%Eof = -1

#If Not %Def(%FILE_DEFINED)
%FILE_DEFINED = 1
Type iobuf
   Ptr      As Asciiz Ptr   ' char *_ptr
   cnt      As Long         ' int   _cnt
   Base     As Asciiz Ptr   ' char *_base
   flag     As Long         ' int   _flag
   file     As Long         ' int   _file
   charbuf  As Long         ' int   _charbuf
   bufsiz   As Long         ' int   _bufsiz
   tmpfname As Asciiz Ptr   ' char *_tmpfname
End Type

'typedef struct _iobuf FILE;
Type FILE
   Ptr      As Asciiz Ptr   ' char *_ptr
   cnt      As Long         ' int   _cnt
   Base     As Asciiz Ptr   ' char *_base
   flag     As Long         ' int   _flag
   file     As Long         ' int   _file
   charbuf  As Long         ' int   _charbuf
   bufsiz   As Long         ' int   _bufsiz
   tmpfname As Asciiz Ptr   ' char *_tmpfname
End Type
#EndIf

'/* Directory where temporary files may be created. */

'#define _P_tmpdir   "\\"
'#define _wP_tmpdir  L"\\"

'/* L_tmpnam = size of P_tmpdir
' *            + 1 (in case P_tmpdir does not end in "/")
' *            + 12 (for the filename string)
' *            + 1 (for the null terminator)
' */
'#define L_tmpnam sizeof(_P_tmpdir)+12

'/* Seek method constants */

%SEEK_CUR     = 1
%SEEK_END     = 2
%SEEK_SET     = 0

%FILENAME_MAX = 260
%FOPEN_MAX    = 20
%SYS_OPEN     = 20
%TMP_MAX      = 32767

'/* Declare _iob[] array */

#If Not %Def(%STDIO_DEFINED)
'_CRTIMP extern FILE _iob[];
Function pb_iob () As Dword
   Local hLib As Dword
   Local piob As FILE Ptr
   hLib = LoadLibrary("msvcrt.dll")
   If hLib Then
      piob = GetProcAddress(hLib, "_iob")
      Function = piob
      FreeLibrary hLib
   End If
End Function
#EndIf   '  /* _STDIO_DEFINED */

'/* Define file position type */

'typedef __int64 fpos_t;

%IOREAD         = &H0001
%IOWRT          = &H0002

%IOFBF          = &H0000
%IOLBF          = &H0040
%IONBF          = &H0004

%IOMYBUF        = &H0008
%IOEOF          = &H0010
%IOERR          = &H0020
%IOSTRG         = &H0040
%IORW           = &H0080

'/* Function prototypes */

#If Not %Def(%STDIO_DEFINED)
%STDIO_DEFINED = 1

'_CRTIMP int __cdecl _filbuf(FILE *);
Declare Function filbuf CDecl Lib "msvcrt.dll" Alias "_filbuf" ( _
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Long                                ' int

'_CRTIMP int __cdecl _flsbuf(int, FILE *);
Declare Function flsbuf CDecl Lib "msvcrt.dll" Alias "_flsbuf" ( _
   ByVal Long, _                            ' int
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Long                                ' int

'_CRTIMP FILE * __cdecl _fsopen(const char *, const char *, int);
Declare Function fsopen CDecl Lib "msvcrt.dll" Alias "_fsopen" ( _
   ByRef Asciiz, _                          ' const char *filename
   ByRef Asciiz, _                          ' const char *mode
   ByVal Long _                             ' int shflag
   ) As Dword                               ' FILE *

'_CRTIMP void __cdecl clearerr(FILE *);
Declare Sub clearerr CDecl Lib "msvcrt.dll" Alias "clearerr" ( _
   ByVal FILE Ptr _                         ' FILE *stream
   )                                        ' void

'_CRTIMP int __cdecl fclose(FILE *);
Declare Function fclose CDecl Lib "msvcrt.dll" Alias "fclose" ( _
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Long                                ' int

'_CRTIMP int __cdecl _fcloseall(void);
Declare Sub fcloseall CDecl Lib "msvcrt.dll" Alias "_fcloseall" ()

'_CRTIMP FILE * __cdecl _fdopen(int, const char *);
Declare Function fdopen CDecl Lib "msvcrt.dll" Alias "_fdopen" ( _
   ByVal Long, _                            ' int fd
   ByRef Asciiz _                           ' const char *mode
   ) As Dword                               ' FILE *

'_CRTIMP int __cdecl feof(FILE *);
Declare Function feof CDecl Lib "msvcrt.dll" Alias "feof" ( _
   ByVal FILE Ptr _                         ' FILE *
   ) As Long                                ' int

'_CRTIMP int __cdecl ferror(FILE *);
Declare Function ferror CDecl Lib "msvcrt.dll" Alias "ferror" ( _
   ByVal FILE Ptr _                         ' FILE *
   ) As Long                                ' int

'_CRTIMP int __cdecl fflush(FILE *);
Declare Function fflush CDecl Lib "msvcrt.dll" Alias "fflush" ( _
   ByVal FILE Ptr _                         ' FILE *
   ) As Long                                ' int

'_CRTIMP int __cdecl fgetc(FILE *);
Declare Function fgetc CDecl Lib "msvcrt.dll" Alias "fgetc" ( _
   ByVal FILE Ptr _                         ' FILE *
   ) As Long                                ' int

'_CRTIMP int __cdecl _fgetchar(void);
Declare Function fgetchar CDecl Lib "msvcrt.dll" Alias "_fgetchar" ( _
   ) As Long                                ' int

'_CRTIMP int __cdecl fgetpos(FILE *, fpos_t *);
Declare Function fgetpos CDecl Lib "msvcrt.dll" Alias "fgetpos" ( _
   ByVal FILE Ptr, _                        ' FILE *
   ByRef Quad _                             ' fpos_t *pos
   ) As Long                                ' int

'_CRTIMP char * __cdecl fgets(char *, int, FILE *);
Declare Function fgets CDecl Lib "msvcrt.dll" Alias "fgets" ( _
   ByRef Asciiz, _                          ' char *string
   ByVal Long, _                            ' int n
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Dword                               ' char *

'_CRTIMP int __cdecl _fileno(FILE *);
Declare Function fileno CDecl Lib "msvcrt.dll" Alias "_fileno" ( _
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Long                                ' int

'_CRTIMP int __cdecl _flushall(void);
Declare Function flushall CDecl Lib "msvcrt.dll" Alias "_flushall" ( _
   ) As Long                                ' int

'_CRTIMP FILE * __cdecl fopen(const char *, const char *);
Declare Function fopen CDecl Lib "msvcrt.dll" Alias "fopen" ( _
   ByRef Asciiz, _                          ' const char *filename
   ByRef Asciiz _                           ' const char *mode
   ) As Dword                               ' FILE *

'_CRTIMP int __cdecl fprintf(FILE *, const char *, ...);
Declare Function fprintf CDecl Lib "msvcrt.dll" Alias "fprintf" ( _
   ByVal FILE Ptr, _                        ' FILE *stream
   ByRef Asciiz, _                          ' const char *format
   Optional ByVal p1 As Any, _              ' optional arguments
   ByVal p2 As Any, _
   ByVal p3 As Any, _
   ByVal p4 As Any, _
   ByVal p5 As Any, _
   ByVal p6 As Any, _
   ByVal p7 As Any, _
   ByVal p8 As Any, _
   ByVal p9 As Any, _
   ByVal p10 As Any, _
   ByVal p11 As Any, _
   ByVal p12 As Any _
   ) As Long                                ' int


'_CRTIMP int __cdecl fputc(int, FILE *);
Declare Function fputc CDecl Lib "msvcrt.dll" Alias "fputc" ( _
   ByVal Long, _                            ' int c
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Long                                ' int

'_CRTIMP int __cdecl _fputchar(int);
Declare Function fputchar CDecl Lib "msvcrt.dll" Alias "_fputchar" ( _
   ByVal Long _                             ' int c
   ) As Long                                ' int

'_CRTIMP int __cdecl fputs(const char *, FILE *);
Declare Function fputs CDecl Lib "msvcrt.dll" Alias "fputs" ( _
   ByRef Asciiz, _                          ' const char *string
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Long                                ' int

'_CRTIMP size_t __cdecl fread(void *, size_t, size_t, FILE *);
Declare Function fread CDecl Lib "msvcrt.dll" Alias "fread" ( _
   ByVal Dword, _                           ' void *buffer
   ByVal Dword, _                           ' size_t size
   ByVal Dword, _                           ' size_t count
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Dword                               ' size_t

'_CRTIMP FILE * __cdecl freopen(const char *, const char *, FILE *);
Declare Function freopen CDecl Lib "msvcrt.dll" Alias "freopen" ( _
   ByRef Asciiz, _                          ' const char *path
   ByRef Asciiz, _                          ' const char* mode
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Dword                               ' FILE *

'_CRTIMP int __cdecl fscanf(FILE *, const char *, ...);
Declare Function fscanf CDecl Lib "msvcrt.dll" Alias "fscanf" ( _
   ByVal FILE Ptr, _                        ' FILE *stream
   ByRef Asciiz, _                          ' const char *format
   Optional ByVal p1 As Any, _              ' optional arguments
   ByVal p2 As Any, _
   ByVal p3 As Any, _
   ByVal p4 As Any, _
   ByVal p5 As Any, _
   ByVal p6 As Any, _
   ByVal p7 As Any, _
   ByVal p8 As Any, _
   ByVal p9 As Any, _
   ByVal p10 As Any, _
   ByVal p11 As Any, _
   ByVal p12 As Any _
   ) As Long                                ' int

'_CRTIMP int __cdecl fsetpos(FILE *, const fpos_t *);
Declare Function fsetpos CDecl Lib "msvcrt.dll" Alias "fsetpos" ( _
   ByVal FILE Ptr, _                        ' FILE *stream
   ByRef Quad _                             ' const fpos_t *pos
   ) As Long                                ' int

'_CRTIMP int __cdecl fseek(FILE *, long, int);
Declare Function fseek CDecl Lib "msvcrt.dll" Alias "fseek" ( _
   ByVal FILE Ptr, _                        ' FILE *stream
   ByVal Long, _                            ' long offset
   ByVal Long _                             ' int origin
   ) As Long                                ' int

'_CRTIMP long __cdecl ftell(FILE *);
Declare Function ftell CDecl Lib "msvcrt.dll" Alias "ftell" ( _
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Long                                ' long

'_CRTIMP size_t __cdecl fwrite(const void *, size_t, size_t, FILE *);
Declare Function fwrite CDecl Lib "msvcrt.dll" Alias "fwrite" ( _
   ByVal Dword, _                           ' const void *buffer
   ByVal Dword, _                           ' size_t size
   ByVal Dword, _                           ' size_t count
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Dword                               ' size_t

'_CRTIMP int __cdecl getc(FILE *);
Declare Function getc CDecl Lib "msvcrt.dll" Alias "getc" ( _
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Long                                ' int

'_CRTIMP int __cdecl getchar(void);
Declare Function getchar CDecl Lib "msvcrt.dll" Alias "getchar" ( _
   ) As Long                                ' int

'_CRTIMP int __cdecl _getmaxstdio(void);
Declare Function getmaxstdio CDecl Lib "msvcrt.dll" Alias "_getmaxstdio" ( _
   ) As Long                                ' int

'_CRTIMP char * __cdecl gets(char *);
Declare Function gets CDecl Lib "msvcrt.dll" Alias "gets" ( _
   ByRef Asciiz _                           ' char *buffer
   ) As Dword                               ' char *

'_CRTIMP int __cdecl _getw(FILE *);
Declare Function getw CDecl Lib "msvcrt.dll" Alias "_getw" ( _
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Long                                ' int

'_CRTIMP void __cdecl perror(const char *);
' Note: Also defined in stdlib.h
Declare Sub perror CDecl Lib "msvcrt.dll" Alias "perror" ( _
   ByRef Asciiz _                           ' const char *string
   )                                        ' void

'_CRTIMP int __cdecl _pclose(FILE *);
Declare Function pclose CDecl Lib "msvcrt.dll" Alias "_pclose" ( _
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Long                                ' int

'_CRTIMP FILE * __cdecl _popen(const char *, const char *);
Declare Function popen CDecl Lib "msvcrt.dll" Alias "_popen" ( _
   ByRef Asciiz, _                          ' const char *command
   ByRef Asciiz _                           ' const char *mode
   ) As Dword                               ' FILE *

'_CRTIMP int __cdecl printf(const char *, ...);
Declare Function printf CDecl Lib "msvcrt.dll" Alias "printf" ( _
   ByRef Asciiz, _                          ' const char *format
   Optional ByVal p1 As Any, _              ' optional arguments
   ByVal p2 As Any, _
   ByVal p3 As Any, _
   ByVal p4 As Any, _
   ByVal p5 As Any, _
   ByVal p6 As Any, _
   ByVal p7 As Any, _
   ByVal p8 As Any, _
   ByVal p9 As Any, _
   ByVal p10 As Any, _
   ByVal p11 As Any, _
   ByVal p12 As Any _
   ) As Long                                ' int

'_CRTIMP int __cdecl putc(int, FILE *);
Declare Function putc CDecl Lib "msvcrt.dll" Alias "putc" ( _
   ByVal Long, _                            ' int c
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Long                                ' int

'_CRTIMP int __cdecl putchar(int);
Declare Function putchar CDecl Lib "msvcrt.dll" Alias "putchar" ( _
   ByVal Long _                             ' int c
   ) As Long                                ' int

'_CRTIMP int __cdecl puts(const char *);
Declare Function puts CDecl Lib "msvcrt.dll" Alias "puts" ( _
   ByRef Asciiz _                           ' const char *string
   ) As Long                                ' int

'_CRTIMP int __cdecl _putw(int, FILE *);
Declare Function putw CDecl Lib "msvcrt.dll" Alias "_putw" ( _
   ByVal Long, _                            ' int binint
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Long                                ' int

'_CRTIMP int __cdecl remove(const char *);
Declare Function remove CDecl Lib "msvcrt.dll" Alias "remove" ( _
   ByRef Asciiz _                           ' const char *path
   ) As Long                                ' int

'_CRTIMP int __cdecl rename(const char *, const char *);
Declare Function rename CDecl Lib "msvcrt.dll" Alias "rename" ( _
   ByRef Asciiz, _                          ' const char *oldname
   ByRef Asciiz _                           ' const char *newname
   ) As Long                                ' int

'_CRTIMP void __cdecl rewind(FILE *);
Declare Sub rewind CDecl Lib "msvcrt.dll" Alias "rewind" ( _
   ByVal FILE Ptr _                         ' FILE *stream
   )                                        ' void

'_CRTIMP int __cdecl _rmtmp(void);
Declare Function rmtmp CDecl Lib "msvcrt.dll" Alias "_rmtmp" ( _
   ) As Long                                ' int

'_CRTIMP int __cdecl scanf(const char *, ...);
Declare Function scanf CDecl Lib "msvcrt.dll" Alias "scanf" ( _
   ByRef Asciiz, _                          ' const char *format
   Optional ByVal p1 As Any, _              ' optional arguments
   ByVal p2 As Any, _
   ByVal p3 As Any, _
   ByVal p4 As Any, _
   ByVal p5 As Any, _
   ByVal p6 As Any, _
   ByVal p7 As Any, _
   ByVal p8 As Any, _
   ByVal p9 As Any, _
   ByVal p10 As Any, _
   ByVal p11 As Any, _
   ByVal p12 As Any _
   ) As Long                                ' int

'_CRTIMP void __cdecl setbuf(FILE *, char *);
Declare Sub setbuf CDecl Lib "msvcrt.dll" Alias "setbuf" ( _
   ByVal FILE Ptr, _                        ' FILE *stream
   ByRef Asciiz _                           ' char *buffer
   )                                        ' void

'_CRTIMP int __cdecl _setmaxstdio(int);
Declare Function setmaxstdio CDecl Lib "msvcrt.dll" Alias "_setmaxstdio" ( _
   ByVal Long _                             ' int newmax
   ) As Long                                ' int

'_CRTIMP int __cdecl setvbuf(FILE *, char *, int, size_t);
Declare Function setvbuf CDecl Lib "msvcrt.dll" Alias "setvbuf" ( _
   ByVal FILE Ptr, _                        ' FILE *stream
   ByRef Asciiz, _                          ' char *buffer
   ByVal Long, _                            ' int mode
   ByVal Dword _                            ' size_t size
   ) As Long                                ' int

'_CRTIMP int __cdecl _snprintf(char *, size_t, const char *, ...);
Declare Function snprintf CDecl Lib "msvcrt.dll" Alias "_snprintf" ( _
   ByRef Asciiz, _                          ' char *buffer
   ByVal Dword, _                           ' size_t count
   ByRef Asciiz, _                          ' const char *format
   Optional ByVal p1 As Any, _              ' optional arguments
   ByVal p2 As Any, _
   ByVal p3 As Any, _
   ByVal p4 As Any, _
   ByVal p5 As Any, _
   ByVal p6 As Any, _
   ByVal p7 As Any, _
   ByVal p8 As Any, _
   ByVal p9 As Any, _
   ByVal p10 As Any, _
   ByVal p11 As Any, _
   ByVal p12 As Any _
   ) As Long                                ' int

'_CRTIMP int __cdecl sprintf(char *, const char *, ...);
Declare Function sprintf CDecl Lib "msvcrt.dll" Alias "sprintf" ( _
   ByRef Asciiz, _                          ' char *buffer
   ByRef Asciiz, _                          ' const char *format
   Optional ByVal p1 As Any, _              ' optional arguments
   ByVal p2 As Any, _
   ByVal p3 As Any, _
   ByVal p4 As Any, _
   ByVal p5 As Any, _
   ByVal p6 As Any, _
   ByVal p7 As Any, _
   ByVal p8 As Any, _
   ByVal p9 As Any, _
   ByVal p10 As Any, _
   ByVal p11 As Any, _
   ByVal p12 As Any _
   ) As Long                                ' int

'_CRTIMP int __cdecl sscanf(const char *, const char *, ...);
Declare Function sscanf CDecl Lib "msvcrt.dll" Alias "sscanf" ( _
   ByRef Asciiz, _                          ' const char *str
   ByRef Asciiz, _                          ' const char *format
   Optional ByVal p1 As Any, _              ' optional arguments
   ByVal p2 As Any, _
   ByVal p3 As Any, _
   ByVal p4 As Any, _
   ByVal p5 As Any, _
   ByVal p6 As Any, _
   ByVal p7 As Any, _
   ByVal p8 As Any, _
   ByVal p9 As Any, _
   ByVal p10 As Any, _
   ByVal p11 As Any, _
   ByVal p12 As Any _
   ) As Long                                ' int

'_CRTIMP char * __cdecl _tempnam(const char *, const char *);
Declare Function tempnam CDecl Lib "msvcrt.dll" Alias "_tempnam" ( _
   ByRef Asciiz, _                          ' const char *dir
   ByRef Asciiz _                           ' const char *prefix
   ) As Dword                               ' char*

Function pb_tempnam (ByRef szdir As Asciiz, ByRef szprefix As Asciiz) As String
   Local psz As Asciiz Ptr
   psz = tempnam(szdir, szprefix)
   If psz Then Function = @psz
End Function

'_CRTIMP FILE * __cdecl tmpfile(void);
Declare Function tmpfile CDecl Lib "msvcrt.dll" Alias "tmpfile" ( _
   ) As Dword                               ' FILE *

'_CRTIMP char * __cdecl tmpnam(char *);
Declare Function tmpnam CDecl Lib "msvcrt.dll" Alias "tmpnam" ( _
   ByRef Asciiz _                           ' char *string
   ) As Dword                               ' char *

'_CRTIMP int __cdecl ungetc(int, FILE *);
Declare Function ungetc CDecl Lib "msvcrt.dll" Alias "ungetc" ( _
   ByVal Long, _                            ' int c
   ByVal FILE Ptr _                         ' FILE *
   ) As Long                                ' int

'_CRTIMP int __cdecl _unlink(const char *);
Declare Function unlink CDecl Lib "msvcrt.dll" Alias " _unlink" (_
   ByRef Asciiz _                           ' const char *filename
   ) As Long                                ' int

'_CRTIMP int __cdecl vfprintf(FILE *, const char *, va_list);
Declare Function vfprintf CDecl Lib "msvcrt.dll" Alias "vfprintf" (_
   ByVal FILE Ptr, _                        ' FILE *stream
   ByRef Asciiz, _                          ' const char *format
   ByVal Dword _                            ' va_list argptr
   ) As Long                                ' int

'_CRTIMP int __cdecl vprintf(const char *, va_list);
Declare Function vprintf CDecl Lib "msvcrt.dll" Alias "vprintf" (_
   ByRef Asciiz, _                          ' const char *format
   ByVal Dword _                            ' va_list argptr
   ) As Long                                ' int

'_CRTIMP int __cdecl _vsnprintf(char *, size_t, const char *, va_list);
Declare Function vsnprintf CDecl Lib "msvcrt.dll" Alias "_vsnprintf" (_
   ByRef Asciiz, _                          ' char *buffer
   ByVal Dword, _                           ' size_t count
   ByRef Asciiz, _                          ' const char *format
   ByVal Dword _                            ' va_list argptr
   ) As Long                                ' int

'_CRTIMP int __cdecl vsprintf(char *, const char *, va_list);
Declare Function vsprintf CDecl Lib "msvcrt.dll" Alias "vsprintf" (_
   ByRef Asciiz, _                          ' char *buffer
   ByRef Asciiz, _                          ' const char *format
   ByVal Dword _                            ' va_list argptr
   ) As Long                                ' int

#If Not %Def(%WSTDIO_DEFINED)
%WSTDIO_DEFINED = 1

'/* wide function prototypes, also declared in wchar.h  */

#If Not %Def(%WEOF)
%WEOF = &HFFFF??
#EndIf

'_CRTIMP FILE * __cdecl _wfsopen(const wchar_t *, const wchar_t *, int);
Declare Function wfsopen CDecl Lib "msvcrt.dll" Alias "_wfsopen" (_
   ByVal Dword, _                           ' const wchar_t *filename
   ByVal Dword, _                           ' const wchar_t *mode
   ByVal Long _                             ' int shflag
   ) As Dword                               ' FILE *

'_CRTIMP wint_t __cdecl fgetwc(FILE *);
Declare Function fgetwc CDecl Lib "msvcrt.dll" Alias "fgetwc" ( _
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Word                                ' wint_t

'_CRTIMP wint_t __cdecl _fgetwchar(void);
Declare Function fgetwchar CDecl Lib "msvcrt.dll" Alias "_fgetwchar" ( _
   ) As Word                                ' wint_t

'_CRTIMP wint_t __cdecl fputwc(wint_t, FILE *);
Declare Function fputwc CDecl Lib "msvcrt.dll" Alias "fputwc" ( _
   ByVal Word, _                            ' wint_t c
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Word                                ' wint_t

'_CRTIMP wint_t __cdecl _fputwchar(wint_t);
Declare Function fputwchar CDecl Lib "msvcrt.dll" Alias "_fputwchar" ( _
   ByVal Word _                             ' wint_t c
   ) As Word                                ' wint_t

'_CRTIMP wint_t __cdecl getwc(FILE *);
Declare Function getwc CDecl Lib "msvcrt.dll" Alias "getwc" ( _
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Word                                ' wint_t

'_CRTIMP wint_t __cdecl getwchar(void);
Declare Function getwchar CDecl Lib "msvcrt.dll" Alias "getwchar" ( _
   ) As Word                                ' wint_t

'_CRTIMP wint_t __cdecl putwc(wint_t, FILE *);
Declare Function putwc CDecl Lib "msvcrt.dll" Alias "putwc" ( _
   ByVal Word, _                            ' wint_t c
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Word                                ' wint_t

'_CRTIMP wint_t __cdecl putwchar(wint_t);
Declare Function putwchar CDecl Lib "msvcrt.dll" Alias "putwchar" ( _
   ByVal Word _                             ' wint_t c
   ) As Word                                ' wint_t

'_CRTIMP wint_t __cdecl ungetwc(wint_t, FILE *);
Declare Function ungetwc CDecl Lib "msvcrt.dll" Alias "ungetwc" ( _
   ByVal Word, _                            ' wint_t c
   ByVal FILE Ptr _                         ' FILE *
   ) As Word                                ' wint_t

'_CRTIMP wchar_t * __cdecl fgetws(wchar_t *, int, FILE *);
Declare Function fgetws CDecl Lib "msvcrt.dll" Alias "fgetws" ( _
   ByVal Dword, _                           ' wchar_t *string
   ByVal Long, _                            ' int n
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Dword                               ' wchar_t *

'_CRTIMP int __cdecl fputws(const wchar_t *, FILE *);
Declare Function fputws CDecl Lib "msvcrt.dll" Alias "fputws" ( _
   ByVal Dword, _                           ' const wchar_t *string
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Long                                ' int

'_CRTIMP wchar_t * __cdecl _getws(wchar_t *);
Declare Function getws CDecl Lib "msvcrt.dll" Alias "_getws" ( _
   ByVal Dword _                            ' wchar_t *buffer
   ) As Dword                               ' wchar_t *

'_CRTIMP int __cdecl _putws(const wchar_t *);
Declare Function putws CDecl Lib "msvcrt.dll" Alias "_putws" ( _
   ByVal Dword _                            ' const wchar_t *string
   ) As Long                                ' int

'_CRTIMP int __cdecl fwprintf(FILE *, const wchar_t *, ...);
Declare Function fwprintf CDecl Lib "msvcrt.dll" Alias "fwprintf" ( _
   ByVal FILE Ptr, _                        ' FILE *stream
   ByVal Dword, _                           ' const wchar_t *format
   Optional ByVal p1 As Any, _              ' optional arguments
   ByVal p2 As Any, _
   ByVal p3 As Any, _
   ByVal p4 As Any, _
   ByVal p5 As Any, _
   ByVal p6 As Any, _
   ByVal p7 As Any, _
   ByVal p8 As Any, _
   ByVal p9 As Any, _
   ByVal p10 As Any, _
   ByVal p11 As Any, _
   ByVal p12 As Any _
   ) As Long                                ' int

'_CRTIMP int __cdecl wprintf(const wchar_t *, ...);
Declare Function wprintf CDecl Lib "msvcrt.dll" Alias "wprintf" ( _
   ByVal Dword, _                           ' const wchar_t *format
   Optional ByVal p1 As Any, _              ' optional arguments
   ByVal p2 As Any, _
   ByVal p3 As Any, _
   ByVal p4 As Any, _
   ByVal p5 As Any, _
   ByVal p6 As Any, _
   ByVal p7 As Any, _
   ByVal p8 As Any, _
   ByVal p9 As Any, _
   ByVal p10 As Any, _
   ByVal p11 As Any, _
   ByVal p12 As Any _
   ) As Long                                ' int

'_CRTIMP int __cdecl _snwprintf(wchar_t *, size_t, const wchar_t *, ...);
Declare Function snwprintf CDecl Lib "msvcrt.dll" Alias "_snwprintf" ( _
   ByVal Dword, _                           ' wchar_t *buffer
   ByVal Dword, _                           ' size_t count
   ByVal Dword, _                           ' wchar_t char *format
   Optional ByVal p1 As Any, _              ' optional arguments
   ByVal p2 As Any, _
   ByVal p3 As Any, _
   ByVal p4 As Any, _
   ByVal p5 As Any, _
   ByVal p6 As Any, _
   ByVal p7 As Any, _
   ByVal p8 As Any, _
   ByVal p9 As Any, _
   ByVal p10 As Any, _
   ByVal p11 As Any, _
   ByVal p12 As Any _
   ) As Long                                ' int

'_CRTIMP int __cdecl swprintf(wchar_t *, const wchar_t *, ...);
Declare Function swprintf CDecl Lib "msvcrt.dll" Alias "swprintf" ( _
   ByVal Dword, _                           ' wchar_t *buffer
   ByVal Dword, _                           ' const wchar_t *format
   Optional ByVal p1 As Any, _              ' optional arguments
   ByVal p2 As Any, _
   ByVal p3 As Any, _
   ByVal p4 As Any, _
   ByVal p5 As Any, _
   ByVal p6 As Any, _
   ByVal p7 As Any, _
   ByVal p8 As Any, _
   ByVal p9 As Any, _
   ByVal p10 As Any, _
   ByVal p11 As Any, _
   ByVal p12 As Any _
   ) As Long                                ' int

'_CRTIMP int __cdecl vfwprintf(FILE *, const wchar_t *, va_list);
Declare Function vfwprintf CDecl Lib "msvcrt.dll" Alias "vfwprintf" (_
   ByVal FILE Ptr, _                        ' FILE *stream
   ByVal Dword, _                           ' const wchar_t *format
   ByVal Dword _                            ' va_list argptr
   ) As Long                                ' int

'_CRTIMP int __cdecl vwprintf(const wchar_t *, va_list);
Declare Function vwprintf CDecl Lib "msvcrt.dll" Alias "vwprintf" (_
   ByVal Dword, _                           ' const wchar_t *format
   ByVal Dword _                            ' va_list argptr
   ) As Long                                ' int

'_CRTIMP int __cdecl _vsnwprintf(wchar_t *, size_t, const wchar_t *, va_list);
Declare Function vsnwprintf CDecl Lib "msvcrt.dll" Alias "_vsnwprintf" (_
   ByVal Dword, _                           ' wchar_t *buffer
   ByVal Dword, _                           ' size_t count
   ByVal Dword, _                           ' const wchar_t *format
   ByVal Dword _                            ' va_list argptr
   ) As Long                                ' int

'_CRTIMP int __cdecl vswprintf(wchar_t *, const wchar_t *, va_list);
Declare Function vswprintf CDecl Lib "msvcrt.dll" Alias "vswprintf" (_
   ByVal Dword, _                           ' wchar_t *buffer
   ByVal Dword, _                           ' const wchar_t *format
   ByVal Dword _                            ' va_list argptr
   ) As Long                                ' int

'_CRTIMP int __cdecl fwscanf(FILE *, const wchar_t *, ...);
Declare Function fwscanf CDecl Lib "msvcrt.dll" Alias "fwscanf" ( _
   ByVal FILE Ptr, _                        ' FILE *stream
   ByVal Dword, _                           ' const wchar_t *format
   Optional ByVal p1 As Any, _              ' optional arguments
   ByVal p2 As Any, _
   ByVal p3 As Any, _
   ByVal p4 As Any, _
   ByVal p5 As Any, _
   ByVal p6 As Any, _
   ByVal p7 As Any, _
   ByVal p8 As Any, _
   ByVal p9 As Any, _
   ByVal p10 As Any, _
   ByVal p11 As Any, _
   ByVal p12 As Any _
   ) As Long                                ' int

'_CRTIMP int __cdecl swscanf(const wchar_t *, const wchar_t *, ...);
Declare Function swscanf CDecl Lib "msvcrt.dll" Alias "swscanf" ( _
   ByVal Dword, _                           ' const wchar_t *str
   ByVal Dword, _                           ' const wchar_t *format
   Optional ByVal p1 As Any, _              ' optional arguments
   ByVal p2 As Any, _
   ByVal p3 As Any, _
   ByVal p4 As Any, _
   ByVal p5 As Any, _
   ByVal p6 As Any, _
   ByVal p7 As Any, _
   ByVal p8 As Any, _
   ByVal p9 As Any, _
   ByVal p10 As Any, _
   ByVal p11 As Any, _
   ByVal p12 As Any _
   ) As Long                                ' int

'_CRTIMP int __cdecl wscanf(const wchar_t *, ...);
Declare Function wscanf CDecl Lib "msvcrt.dll" Alias "wscanf" ( _
   ByVal Dword, _                           ' const wchar_t *format
   Optional ByVal p1 As Any, _              ' optional arguments
   ByVal p2 As Any, _
   ByVal p3 As Any, _
   ByVal p4 As Any, _
   ByVal p5 As Any, _
   ByVal p6 As Any, _
   ByVal p7 As Any, _
   ByVal p8 As Any, _
   ByVal p9 As Any, _
   ByVal p10 As Any, _
   ByVal p11 As Any, _
   ByVal p12 As Any _
   ) As Long                                ' int

'_CRTIMP FILE * __cdecl _wfdopen(int, const wchar_t *);
Declare Function wfdopen CDecl Lib "msvcrt.dll" Alias "_wfdopen" ( _
   ByVal Long, _                            ' int fd
   ByVal Dword _                            ' const wchar_t *mode
   ) As Dword                               ' FILE *

'_CRTIMP FILE * __cdecl _wfopen(const wchar_t *, const wchar_t *);
Declare Function wfopen CDecl Lib "msvcrt.dll" Alias "_wfopen" ( _
   ByVal Dword, _                           ' const wchar_t *filename
   ByVal Dword _                            ' const wchar_t *mode
   ) As Dword                               ' FILE *

'_CRTIMP FILE * __cdecl _wfreopen(const wchar_t *, const wchar_t *, FILE *);
Declare Function wfreopen CDecl Lib "msvcrt.dll" Alias "_wfreopen" ( _
   ByVal Dword, _                           ' const wchar_t *path
   ByVal Dword, _                           ' const wchar_t* mode
   ByVal FILE Ptr _                         ' FILE *stream
   ) As Dword                               ' FILE *

'_CRTIMP void __cdecl _wperror(const wchar_t *);
Declare Sub wperror CDecl Lib "msvcrt.dll" Alias "_wperror" ( _
   ByVal Dword _                            ' const wchar_t *string
   )                                        ' void

'_CRTIMP FILE * __cdecl _wpopen(const wchar_t *, const wchar_t *);
Declare Function wpopen CDecl Lib "msvcrt.dll" Alias "_wpopen" ( _
   ByVal Dword, _                           ' const wchar_t *command
   ByVal Dword _                            ' const wchar_t *mode
   ) As Dword                               ' FILE *

'_CRTIMP int __cdecl _wremove(const wchar_t *);
Declare Function wremove CDecl Lib "msvcrt.dll" Alias "_wremove" ( _
   ByVal Dword _                            ' const wchar_t *path
   ) As Long                                ' int

'_CRTIMP wchar_t * __cdecl _wtempnam(const wchar_t *, const wchar_t *);
Declare Function wtempnam CDecl Lib "msvcrt.dll" Alias "_wtempnam" ( _
   ByVal Dword, _                           ' const wchar_t *dir
   ByVal Dword _                            ' const wchar_t *prefix
   ) As Dword                               ' wchar_t *

'_CRTIMP wchar_t * __cdecl _wtmpnam(wchar_t *);
Declare Function wtmpnam CDecl Lib "msvcrt.dll" Alias "_wtmpnam" ( _
   ByVal Dword _                            ' wchar_t *string
   ) As Dword                               ' wchar_t *

#EndIf   ' /* _WSTDIO_DEFINED */

#EndIf   ' /* _STDIO_DEFINED */

'#pragma pack(pop)

#EndIf   ' #IF NOT %DEF(%STDIO_INC)